# FILE: LandMassesLands.py
# PURPOSE: A script for using LandMasses's land generator.
# VERSION 1.0

# Import the required files.

import operator
from CvPythonExtensions import *
import CvUtil
import CvMapGeneratorUtil
from CvMapGeneratorUtil import FractalWorld
from CvMapGeneratorUtil import TerrainGenerator
from CvMapGeneratorUtil import FeatureGenerator
import pickle
import math

#--------------------------------------------------------------------------------------------------------------------------#
# Predefined variables.
#--------------------------------------------------------------------------------------------------------------------------#

cachedMenuChoices = []
isamodule = False
width = 0
Area = 0
cardinalDirs = [(-1,0),(0,-1),(0,1),(1,0)]
nearDirs = [(-1,-1),(-1,0),(-1,1),(0,-1),(0,1),(1,-1),(1,0),(1,1)]

#--------------------------------------------------------------------------------------------------------------------------#
# Step 1: Generate lands.
#--------------------------------------------------------------------------------------------------------------------------#

def generatePlotTypes(module = False):

        global isamodule

        if not module:
                isamodule = False
        elif module:
                isamodule = True
        
        cymap = CyMap()
	gc = CyGlobalContext()
	dice = gc.getGame().getMapRand()
	saveSettings()

	global width
        global Area
        
	width = cymap.getGridWidth()
	height = cymap.getGridHeight()
	Area = width*height

        # Determine which options have been selected.

        if isamodule:
                settings = open('LandMasses Lands.cfg', 'r')
                SavedSettings = pickle.load(settings)
                Settings = []
                for Option in range(len(selection_names_and_values)):
                        for Choice in range(len(selection_names_and_values[Option])):
                                if SavedSettings[Option][1] == selection_names_and_values[Option][Choice][0]:
                                        Settings.append(selection_names_and_values[Option][Choice][1])
                                        break
                [LandMassCount, MaxLandMassCount, ContinentCount, MaxContinentCount, ContinentDistribution, LandMassShape,
                 SeaWidth, MaxSeaWidth, PercentLand, MaxLand, CoastLines, PercentHills, PercentPeaks, MountainRanges,
                 AltitudeChanges] = Settings
        elif not isamodule:
                LandMassCount = getSelectedMapValue("Min Land Masses:")
                MaxLandMassCount = getSelectedMapValue("Max Land Masses:")
                ContinentCount = getSelectedMapValue("Min Continents:")
                MaxContinentCount = getSelectedMapValue("Max Continents:")
                ContinentDistribution = getSelectedMapValue("Continent Distribution:")
                LandMassShape = getSelectedMapValue("Continent Placement:")
                SeaWidth = getSelectedMapValue("Min Oceanic Seperation:")
                MaxSeaWidth = getSelectedMapValue("Max Oceanic Seperation:")
                PercentLand = getSelectedMapValue("Min Ocean:")
                MaxLand = getSelectedMapValue("Max Ocean:")
                CoastLines = getSelectedMapValue("Coastlines:")
                PercentHills = getSelectedMapValue("Hills:")
                PercentPeaks = getSelectedMapValue("Peaks:")
                MountainRanges = getSelectedMapValue("Mountain Ranges:")
                AltitudeChanges = getSelectedMapValue("Altitude Changes:")

	landmass = 0
	continent = 0
	problem = 0
	check = False
	CanBeLandLists = []
	OwnerLandMasses = [-1]*(Area)
	OwnerContinents = [-1]*(Area)
	fillType = PlotTypes.PLOT_OCEAN
	plotTypes = [fillType]*(Area)
	NewplotTypes = [fillType]*(Area)
	PlotAltitude = [0]*(Area)
	NewPlotAltitude = [0]*(Area)
	RestrictedHeight = int(height/8)
	RestrictedAreaOne = RestrictedHeight*width
	RestrictedAreaTwo = Area - 2*RestrictedAreaOne
	LandPlaced = 0
	RestoreLake = 0
	HillsPlaced = 0
	PeaksPlaced = 0

	# Find the minimum seperation between land masses.

	if (MaxSeaWidth >= 0 and MaxSeaWidth != SeaWidth):
                DiffSeaWidth = abs(MaxSeaWidth - SeaWidth) + 1
                SeaWidth = min(SeaWidth, MaxSeaWidth) + dice.get(DiffSeaWidth, "SeaWidth")

        SeaCheckSet = range(-SeaWidth - 3, SeaWidth + 2)

        # Find the amount of sea water covering the map.

	if (MaxLand > 0 and MaxLand != PercentLand):
                DiffLand = abs(MaxLand - PercentLand) + 1
                PercentLand = min(PercentLand, MaxLand) + dice.get(DiffLand, "Land")

        LandFractionOne = (PercentLand*Area)/100.0
        
        # What type of coast lines are to be generated.

        if CoastLines < 0:
                CoastLines = 2 + dice.get(3, "Standard, rougher, or rugged coastlines.")

	# Determine the percentage of land tiles which are hills.
	
	VariantHills = dice.get(100, "Randomly generate the exact percentage of hills.")
	
	if PercentHills == -1:
                PercentHills = 12.5 + (VariantHills/50.0)
	elif PercentHills == -2:
                PercentHills = 14.5 + (VariantHills/50.0)
        elif PercentHills == -3:
                PercentHills = 16.5 + (VariantHills/33.0)
        elif PercentHills == -4:
                PercentHills = 19.5 + (VariantHills/33.0)
        elif PercentHills == -5:
                PercentHills = 22.5 + (VariantHills/33.0)
        elif PercentHills == -6:
                PercentHills = 25.5 + (VariantHills/33.0)
        elif PercentHills == -7:
                PercentHills = 28.5 + (VariantHills/33.0)
        elif PercentHills == -8:
                PercentHills = 31.5 + (VariantHills/33.0)
        elif PercentHills == -9:
                PercentHills = 12.5 + dice.get(33, "Between 12.5% and 34.5% of land is hills.")
        elif PercentHills == 0:
                PercentHills = 40 + dice.get(11, "Between 40% and 50% of land is hills.")

        # Determine the percentage of land tiles which are peaks.

	VariantPeaks = dice.get(100, "Randomly generate the exact percentage of peaks.")

	if PercentPeaks == -1:
                PercentPeaks = VariantPeaks/100.0
	elif PercentPeaks == -2:
                PercentPeaks = 1.0 + (VariantPeaks/100.0)
        elif PercentPeaks == -3:
                PercentPeaks = 2.0 + (VariantPeaks/50.0)
        elif PercentPeaks == -4:
                PercentPeaks = 4.0 + (VariantPeaks/50.0)
        elif PercentPeaks == -5:
                PercentPeaks = 6.0 + (VariantPeaks/50.0)
        elif PercentPeaks == -6:
                PercentPeaks = 8.0 + (VariantPeaks/50.0)
        elif PercentPeaks == -7:
                PercentPeaks = 10.0 + (VariantPeaks/50.0)
        elif PercentPeaks == -8:
                PercentPeaks = 12.0 + (VariantPeaks/50.0)
        elif PercentPeaks == -9:
                PercentPeaks = dice.get(15, "Between 0% and 14% of land is peaks.")
        elif PercentPeaks == 0:
                PercentPeaks = 20 + dice.get(11, "Between 20% and 30% of land is peaks.")

        # Are mountain ranges generated?.

        if MountainRanges < 0:
                MountainRanges = 0 + dice.get(3, "No ranges, ranges, or all ranges.")

        # Are altitude changes slow or rapid?

        if AltitudeChanges < 0:
                AltitudeChanges = 0 + dice.get(2, "Altitudes; clumped or not clumped.")
        
        # Find the number of land masses.

	if (MaxLandMassCount > 0 and MaxLandMassCount != LandMassCount):
                DiffLandMassCount = abs(MaxLandMassCount - LandMassCount) + 1
                LandMassCount = min(LandMassCount, MaxLandMassCount) + dice.get(DiffLandMassCount, "Land Masses")

        LandMassTileCount = [0]*LandMassCount

        # Find the number of continents.

	if SeaWidth <= 1 or ContinentCount == 0:
                ContinentCount = LandMassCount
        else:
                if (MaxContinentCount > 0 and MaxContinentCount != ContinentCount):
                        DiffContinentCount = abs(MaxContinentCount - ContinentCount) + 1
                        ContinentCount = min(ContinentCount, MaxContinentCount) + dice.get(DiffContinentCount, "Continents")

	if ContinentCount < LandMassCount:
                ContinentCount = LandMassCount

        ContinentLandMass = [-1]*ContinentCount
        LandFractionTwo = max(LandFractionOne/(2*LandMassCount), SeaWidth**2)
        LandFractionThree = LandFractionOne/(2*ContinentCount)
        LandFractionFour = LandFractionOne/(3*ContinentCount)

        # Find the continent distribution.

        if ContinentDistribution < 0:
                ContinentDistribution = dice.get(2, "True or false.")

        # Find the land mass shape.

        if LandMassShape < 0:
                LandMassShape = dice.get(3, "Rounded, snaky, or normal land masses.")
        
        # Begin land mass generation.

        while (continent < ContinentCount):
                continent += 1
		CanBeLandLists.append([])

	ExpectedLandPlotCount = int(LandFractionOne)
	LandToPlace = int((102*ExpectedLandPlotCount)/100)
	actualLandPlotCount = ContinentCount

        # Generate a starting plot for each continent.

	# If only one continent is to be placed.

	if ContinentCount == 1:
                I = (int(height/2))*width + int(width/2)
                OwnerLandMasses[I] = landmass
                OwnerContinents[I] = continent
                LandMassTileCount[landmass] += 1
                plotTypes[I] = PlotTypes.PLOT_LAND
                PlotAltitude[I] = 1 + dice.get(100, "Altitude.")
                for i in nearDirs:
                        Inew = GetNewTileIndex(I, i)
                        if Inew == -1:
                                continue
                        CanBeLandLists[0].append(Inew)

	# If multiple continents are to be placed.

	elif ContinentCount > 1:

                ContinentTiles = []
                TotalDistances = []

                # Place the first continent.

                I = RestrictedAreaOne + dice.get(RestrictedAreaTwo, "The first land tile.")
                plotTypes[I] = PlotTypes.PLOT_LAND
                OwnerLandMasses[I] = 0
                OwnerContinents[I] = 0
                ContinentLandMass[0] = 0
                LandMassTileCount[landmass] += 1
                PlotAltitude[I] = 1 + dice.get(100, "Altitude.")
                ContinentTiles.append(I)
                for i in nearDirs:
                        Inew = GetNewTileIndex(I, i)
                        if Inew == -1:
                                continue
                        CanBeLandLists[0].append(Inew)

                # Determine the starting plot of each other continent.

                for continent in range(1, ContinentCount):

                        continent -= problem
                        PossibleStartTiles = []

                        # Which land mass is the continent part of?

                        if LandMassCount > continent:
                                landmass = continent
                        elif LandMassCount <= continent:
                                if ContinentDistribution:
                                        landmass = continent
                                        while landmass >= LandMassCount:
                                                landmass -= LandMassCount
                                else:
                                        landmass = dice.get(LandMassCount, "Pick a random land mass.")

                        ContinentLandMass[continent] = landmass

                        # The first tile of the last land mass is to be placed as far from other land as possible.

                        if continent == LandMassCount - 1:
                                FurthestDistance = -1
                                ShortestDistance = Area
                                for I in range(RestrictedAreaOne, RestrictedAreaTwo):
                                        conflict = False
                                        Distance = 0
                                        TotalDistances.append(0)
                                        for Inew in ContinentTiles:
                                                if I == Inew:
                                                        conflict = True
                                                        TotalDistances[I - RestrictedAreaOne] = 0
                                                        break
                                                X, Y = GetDistance(I, Inew)
                                                Distance = X**2 + Y**2
                                                if Distance >= LandFractionTwo:
                                                        TotalDistances[I - RestrictedAreaOne] += Distance
                                                elif Distance < LandFractionTwo:
                                                        conflict = True
                                                        TotalDistances[I - RestrictedAreaOne] = 0
                                                        break
                                        
                                        if not conflict:
                                                if TotalDistances[I - RestrictedAreaOne] > FurthestDistance:
                                                        FurthestDistance = TotalDistances[I - RestrictedAreaOne]
                                                if TotalDistances[I - RestrictedAreaOne] < ShortestDistance:
                                                        ShortestDistance = TotalDistances[I - RestrictedAreaOne]

                                # At what approximate distance from other land masses will the last land mass be placed?
                                
                                if FurthestDistance > 0:
                                        FurthestDistance = (FurthestDistance + ShortestDistance)/2

                                # Assign the starting point of the last land mass.

                                if FurthestDistance > 0:

                                        # Find a plot at the appropriate distance from other land masses.

                                        for I in range(len(TotalDistances)):
                                                TotalDistances[I] -= FurthestDistance
                                                if TotalDistances[I] < 0:
                                                        TotalDistances[I] -= 2*TotalDistances[I]
                                        
                                        FurthestDistance = min(TotalDistances)
                                        PossibleTiles = []

                                        for I in range(len(TotalDistances)):
                                                if TotalDistances[I] == FurthestDistance:
                                                        PossibleTiles.append(I)

                                        I = PossibleTiles[dice.get(len(PossibleTiles), "")] - 1 + RestrictedAreaOne

                                        # Place the land mass starting tile.
                                        
                                        plotTypes[I] = PlotTypes.PLOT_LAND
                                        OwnerLandMasses[I] = landmass
                                        OwnerContinents[I] = continent
                                        LandMassTileCount[landmass] += 1
                                        PlotAltitude[I] = 1 + dice.get(100, "Altitude.")
                                        ContinentTiles.append(I)
                                        for i in nearDirs:
                                                Inew = GetNewTileIndex(I, i)
                                                if Inew == -1:
                                                        continue
                                                CanBeLandLists[continent].append(Inew)

                                # If the last land mass cannot be placed.

                                elif FurthestDistance <= 0:
                                        problem += 1
                                        LandMassCount -= 1
                                        ContinentCount -= 1
                                        del CanBeLandLists[continent]
                                        del ContinentLandMass[continent]
                                        del LandMassTileCount[landmass]
                                        actualLandPlotCount -= 1

                                continue

                        # If more rounded land masses or more snaky land masses have been selected.

                        if LandMassShape > 0:
                                landmasssize = 0
                                for continents in range(continent):
                                        if ContinentLandMass[continents] == landmass:
                                                landmasssize += 1

                        # If more rounded land masses has been selected.

                        if LandMassShape == 1 and landmasssize >= 2:
                                NearestDistance = Area
                                for I in range(RestrictedAreaOne, RestrictedAreaTwo):
                                        conflict = False
                                        MinDistance = -1
                                        TotalDistance = 0
                                        for Inew in ContinentTiles:
                                                if I == Inew:
                                                        conflict = True
                                                        break
                                                X, Y = GetDistance(I, Inew)
                                                Distance = X**2 + Y**2
                                                if OwnerLandMasses[Inew] == landmass:
                                                        TotalDistance += Distance
                                                        if MinDistance < 0:
                                                                MinDistance = Distance
                                                        else:
                                                                MinDistance = min(MinDistance, Distance)
                                                elif OwnerLandMasses[Inew] != landmass:
                                                        if Distance < LandFractionTwo:
                                                                conflict = True
                                                                break

                                        if conflict:
                                                continue

                                        if MinDistance > LandFractionThree:
                                                continue

                                        if MinDistance < LandFractionFour and MinDistance > 0:
                                                continue

                                        if TotalDistance < NearestDistance:
                                                NearestDistance = TotalDistance
                                                Ikept = I

                                # Assign the starting tile of the continent.

                                if FurthestDistance > 0:
                                        plotTypes[Ikept] = PlotTypes.PLOT_LAND
                                        OwnerLandMasses[Ikept] = landmass
                                        OwnerContinents[Ikept] = continent
                                        LandMassTileCount[landmass] += 1
                                        PlotAltitude[Ikept] = 1 + dice.get(100, "Altitude.")
                                        ContinentTiles.append(Ikept)
                                        for i in nearDirs:
                                                Inew = GetNewTileIndex(Ikept, i)
                                                if Inew == -1:
                                                        continue
                                                CanBeLandLists[continent].append(Inew)

                                # If the continent cannot be placed.

                                elif FurthestDistance <= 0:
                                        problem += 1
                                        ContinentCount -= 1
                                        del CanBeLandLists[continent]
                                        del ContinentLandMass[continent]
                                        actualLandPlotCount -= 1

                                continue

                        # If more snaky land masses has been selected.

                        if LandMassShape == 2 and landmasssize >= 2:
                                FurthestDistance = -1
                                for I in range(RestrictedAreaOne, RestrictedAreaTwo):
                                        conflict = False
                                        MinDistance = -1
                                        TotalDistance = 0
                                        for Inew in ContinentTiles:
                                                if I == Inew:
                                                        conflict = True
                                                        break
                                                X, Y = GetDistance(I, Inew)
                                                Distance = X**2 + Y**2
                                                if OwnerLandMasses[Inew] == landmass:
                                                        TotalDistance += Distance
                                                        if MinDistance < 0:
                                                                MinDistance = Distance
                                                        else:
                                                                MinDistance = min(MinDistance, Distance)
                                                elif OwnerLandMasses[Inew] != landmass:
                                                        if Distance < LandFractionTwo:
                                                                conflict = True
                                                                break

                                        if conflict:
                                                continue

                                        if MinDistance > LandFractionThree:
                                                continue

                                        if MinDistance < LandFractionFour and MinDistance > 0:
                                                continue

                                        if TotalDistance > FurthestDistance:
                                                FurthestDistance = TotalDistance
                                                Ikept = I

                                # Assign the starting tile of the continent.

                                if FurthestDistance > 0:
                                        plotTypes[Ikept] = PlotTypes.PLOT_LAND
                                        OwnerLandMasses[Ikept] = landmass
                                        OwnerContinents[Ikept] = continent
                                        LandMassTileCount[landmass] += 1
                                        PlotAltitude[Ikept] = 1 + dice.get(100, "Altitude.")
                                        ContinentTiles.append(Ikept)
                                        for i in nearDirs:
                                                Inew = GetNewTileIndex(Ikept, i)
                                                if Inew == -1:
                                                        continue
                                                CanBeLandLists[continent].append(Inew)

                                # If the last continent cannot be placed.

                                elif FurthestDistance <= 0:
                                        problem += 1
                                        ContinentCount -= 1
                                        del CanBeLandLists[continent]
                                        del ContinentLandMass[continent]
                                        actualLandPlotCount -= 1

                                continue

                        # Determine all possible starting tiles for continents that don't meet the above conditions.

                        for I in range(RestrictedAreaOne, RestrictedAreaTwo):
                                conflict = False
                                MinDistance = -1
                                for Inew in ContinentTiles:
                                        if I == Inew:
                                                conflict = True
                                                break
                                        X, Y = GetDistance(I, Inew)
                                        Distance = X**2 + Y**2
                                        if OwnerLandMasses[Inew] == landmass:
                                                if MinDistance < 0:
                                                        MinDistance = Distance
                                                else:
                                                        MinDistance = min(MinDistance, Distance)
                                        elif OwnerLandMasses[Inew] != landmass:
                                                if Distance < LandFractionTwo:
                                                        conflict = True
                                                        break

                                if conflict:
                                        continue

                                if MinDistance > LandFractionThree:
                                        continue

                                if MinDistance < LandFractionFour and MinDistance > 0:
                                        continue

                                PossibleStartTiles.append(I)

                        # Select the continent's starting tile.

                        if len(PossibleStartTiles) > 0:
                                I = PossibleStartTiles[dice.get(len(PossibleStartTiles), "Pick a possible starting tile.")]
                                plotTypes[I] = PlotTypes.PLOT_LAND
                                OwnerLandMasses[I] = landmass
                                OwnerContinents[I] = continent
                                LandMassTileCount[landmass] += 1
                                PlotAltitude[I] = 1 + dice.get(100, "Altitude.")
                                ContinentTiles.append(I)
                                for i in nearDirs:
                                        Inew = GetNewTileIndex(I, i)
                                        if Inew == -1:
                                                continue
                                        CanBeLandLists[continent].append(Inew)

                        # If no starting position is available.

                        else:

                                problem += 1
                                if LandMassCount > continent:
					LandMassCount -= 1
					del LandMassTileCount[landmass]
                                ContinentCount -= 1
                                del CanBeLandLists[continent]
                                del ContinentLandMass[continent]
                                actualLandPlotCount -= 1

        # If continents are to form mountain ranges, determine which continents do so.

        Ranges = []

        if MountainRanges:
                if MountainRanges == 2:
                        Ranges = range(ContinentCount)
                else:
                        RangeCount = 3 + dice.get(3, "How many continents produce ranges?")
                        if RangeCount >= ContinentCount:
                                Ranges = range(ContinentCount)
                        else:
                                while len(Ranges) < RangeCount:
                                        for continent in range(ContinentCount):
                                                if continent not in Ranges:
                                                        if dice.get(ContinentCount, "") >= RangeCount:
                                                                Ranges.append(continent)
                                                                if len(Ranges) == RangeCount:
                                                                        break

        # Generate the land plots for each continent.

        tries = 0

        while (LandPlaced < CoastLines*LandToPlace/2.0 and tries < 4*CoastLines*LandToPlace):
                for continent in range(ContinentCount):

                        if ContinentCount > 1:
                                if check:
                                        check = False
                                        continent -= 1
                                        if continent < 0:
                                                continent = ContinentCount - 1
                                        landmass = ContinentLandMass[continent]
                                else:
                                        landmass = ContinentLandMass[continent]
                                        if LandMassTileCount[landmass] > 3.0*sum(LandMassTileCount)/(2 + 2*LandMassCount):
                                                continue

                        tries += 1
                        dropProb = 0
                        anyMatch = False

                        # Select a tile to be added to the continent.

                        if CanBeLandLists[continent] == []:
                                continue
                        tile = dice.get(len(CanBeLandLists[continent]), "Select a tile to be added to the continent.")
                        I = CanBeLandLists[continent][tile]

                        # Determine if the tile is too close to another land mass.

                        if (LandMassCount > 1 and not anyMatch):
                                Limit = max(SeaWidth - 2, 2)
                                for i in SeaCheckSet:
                                        for j in SeaCheckSet:
                                                if abs(i) + abs(j) < Limit:
                                                        continue
                                                Inew = GetNewTileIndex(I, (i, j))
                                                if Inew != -1:
                                                        if plotTypes[Inew] == PlotTypes.PLOT_OCEAN:
                                                                continue
                                                        if OwnerLandMasses[Inew] == landmass:
                                                                continue
                                                        X, Y = GetDistance(I, Inew)
                                                        if (X + Y) <= SeaWidth or (X <= SeaWidth and Y <= SeaWidth):
                                                                anyMatch = True
                                                                dropProb = 10001
                                                                break
                                                        sep = int(((X*X) + (Y*Y))**0.5)
                                                        beyondSeaWidthTest = 2000 - (100*(sep - SeaWidth)*(sep - SeaWidth))
                                                        edgeVal = dice.get(10000, "Random Continent sea edge bending")
                                                        if edgeVal < beyondSeaWidthTest:
                                                                dropProb = int(beyondSeaWidthTest/2)
                                                                anyMatch = True
                                                                break
                                                else:
                                                        continue
                                                if anyMatch:
                                                        break

                        # Determine if the tile is too close to the poles.

                        if not anyMatch:
                                if I > Area/2:
                                        IndicesFromEnd = Area - I - 1
                                elif I <= Area/2:
                                        IndicesFromEnd = I
                                (X, Y) = GetDistance(IndicesFromEnd, 0)
                                Y = Y - 2
                                if Y < RestrictedHeight:
                                        Land = dice.get(10000, "Will the tile be land?")
                                        dropProb = (10001*(RestrictedHeight - Y))/RestrictedHeight
                                        if Land < dropProb:
                                                anyMatch = True

                        # If the land tile will not be placed.

                        if anyMatch:
                                drop = dice.get(10000, "Random canbeland drop")
                                if drop < dropProb:
                                        del CanBeLandLists[continent][tile]
                                if not check:
                                        check = True
                                        tries -= 1
                                elif check:
                                        check = False
                                continue

                        # If the land tile will be placed.
                        
                        del CanBeLandLists[continent][tile]

                        if plotTypes[I] == PlotTypes.PLOT_LAND:
                                PlotAltitude[I] += dice.get(100, "Additional altitude.")
                        elif plotTypes[I] == PlotTypes.PLOT_OCEAN:
                                plotTypes[I] = PlotTypes.PLOT_LAND
                                OwnerLandMasses[I] = landmass
                                OwnerContinents[I] = continent
                                LandMassTileCount[landmass] += 1
                                PlotAltitude[I] = 1 + dice.get(100, "Altitude.")
                                LandPlaced += 1

                                # Determine which tiles the continent can now incorporate.

                                for i in nearDirs:
                                        Inew = GetNewTileIndex(I, i)
                                        if Inew != -1:
                                                if not (Inew in CanBeLandLists[continent]):
                                                        if OwnerContinents[Inew] != continent:
                                                                if plotTypes[Inew] == PlotTypes.PLOT_LAND and PlotAltitude[Inew] <= 100 and continent in Ranges:
                                                                        PlotAltitude[Inew] += dice.get(100, "Additional Altitude.")
                                                                elif plotTypes[Inew] == PlotTypes.PLOT_OCEAN:
                                                                        roundTest = dice.get(1000, "Continent growth.")
                                                                        if roundTest < 301:
                                                                                CanBeLandLists[continent].append(Inew)
	
        actualLandPlotCount += LandPlaced

        # Fill in any freshwater lakes.

	for I in range(Area):

		if plotTypes[I] == PlotTypes.PLOT_OCEAN:
			continue

		# Is the land tile adjacent to an ocean tile? If so, determine if it is fresh water or salt water.

		if I > Area/2:
			Inew = GetNewTileIndex(I, cardinalDirs[1])
			if Inew == -1:
                                continue
		elif I <= Area/2:
			Inew = GetNewTileIndex(I, cardinalDirs[2])
			if Inew == -1:
                                continue

		if plotTypes[Inew] == PlotTypes.PLOT_OCEAN:
			oceancount = 1
			tilesused = 0
			LakesTiles = []
			LakesTiles.append(Inew)

			while oceancount < 10:

				tilesused += 1

				for i in cardinalDirs:
					Inext = GetNewTileIndex(Inew, i)
					if Inext != -1:
                                                if plotTypes[Inext] == PlotTypes.PLOT_OCEAN and not (Inext in LakesTiles):
                                                        LakesTiles.append(Inext)
                                                        oceancount += 1

				if oceancount >= 10:
					break

				if tilesused < len(LakesTiles):
					Inew = LakesTiles[tilesused]
				elif tilesused == len(LakesTiles):
					RestoreLake += tilesused
					landmass = OwnerLandMasses[I]
					for j in range(tilesused):
						Inext = LakesTiles[j]
						plotTypes[Inext] = PlotTypes.PLOT_LAND
						LandMassTileCount[landmass] += 1
						PlotAltitude[Inext] = 1
						OwnerLandMasses[Inext] = landmass
					break

	actualLandPlotCount += RestoreLake
        
	# Adjust the amount of ocean tiles to correct the percentage.
	
	landRemovalTries = 0

	while actualLandPlotCount > ExpectedLandPlotCount and landRemovalTries < ExpectedLandPlotCount * 2048:
                
		landRemovalTries += 1

		# Select a land tile for removal.
		
		I = dice.get(Area, "Tile proposed for removal.")
		
		if plotTypes[I] != PlotTypes.PLOT_LAND:
			continue

		if LandMassTileCount[OwnerLandMasses[I]] < 1.0*sum(LandMassTileCount)/(LandMassCount + 1):
                        continue

		# Determine if the tile is adjacent to a coastal tile.
		
		for i in cardinalDirs:
			Inew = GetNewTileIndex(I, i)
			if Inew != -1 and plotTypes[Inew] == fillType:

                                # Set the tile to water.
                                
                                plotTypes[I] = fillType
                                PlotAltitude[I] = 0
                                actualLandPlotCount -= 1
                                landmass = OwnerLandMasses[I]
                                LandMassTileCount[landmass] -= 1
                                OwnerLandMasses[I] = -1

                                # The odds of archipelagos forming increases as the ruggedness of the coast increases.

                                j = dice.get(100, "A random number.")

                                while j < (CoastLines - 1)*25:
                                        
                                        if actualLandPlotCount <= ExpectedLandPlotCount:
                                                j = 100

                                        else:
                                                AdjacentLandMassTiles = []
                                                for i in cardinalDirs:
                                                        Inew = GetNewTileIndex(I, i)
                                                        if Inew != -1 and plotTypes[Inew] == PlotTypes.PLOT_LAND:
                                                                AdjacentLandMassTiles.append(Inew)

                                                # If there are adjacent land tiles, set one to be water.

                                                if len(AdjacentLandMassTiles) > 0:
                                                        I = AdjacentLandMassTiles[dice.get(len(AdjacentLandMassTiles), "")]
                                                        plotTypes[I] = fillType
                                                        PlotAltitude[I] = 0
                                                        actualLandPlotCount -= 1
                                                        LandMassTileCount[landmass] -= 1
                                                        OwnerLandMasses[I] = -1
                                                        j = dice.get(100, "A random number.")

                                                else:
                                                        j = 100

                                break

	# Alter the rate at which altitude changes.

	if AltitudeChanges:
                for I in range(Area):

                        if plotTypes[I] == PlotTypes.PLOT_OCEAN:
                                continue

                        LandTile = 0
                        NearAltitude = 0

                        for i in nearDirs:
                                Inext = GetNewTileIndex(I, i)
                                if Inext != -1:
                                        if plotTypes[Inext] == PlotTypes.PLOT_LAND:
                                                LandTile += 1
                                                NearAltitude += PlotAltitude[Inext]

                        if LandTile > 0:
                                NewPlotAltitude[I] = int((PlotAltitude[I] + NearAltitude/LandTile)/2)
                        else:
                                NewPlotAltitude[I] = PlotAltitude[I]

        else:
                for I in range(Area):
                        NewPlotAltitude[I] = PlotAltitude[I]
                                        
        
	# Place peaks.

	RequiredPeakCount = int((PercentPeaks*actualLandPlotCount)/100)

	while PeaksPlaced < RequiredPeakCount:
		
		MaxAltitude = max(NewPlotAltitude)
		NewPeaks = []

                for I in range(Area):
                        if NewPlotAltitude[I] == MaxAltitude:
                                plotTypes[I] = PlotTypes.PLOT_PEAK
                                NewPeaks.append([I])
                                NewPlotAltitude[I] = 0
                                PeaksPlaced += 1

        # Remove excess peaks.

        if PeaksPlaced > RequiredPeakCount:
		
                ExcessPeaks = PeaksPlaced - RequiredPeakCount
                
                for N in range(ExcessPeaks):
                        I = dice.get(len(NewPeaks), "Pick a smaller peak.")
                        for J in range(Area):
                                if J in NewPeaks[I]:
                                        plotTypes[J] = PlotTypes.PLOT_HILLS
                                        del NewPeaks[I]
                                        PeaksPlaced -= 1
                                        HillsPlaced += 1
                                        break

        # Place hills.

        RequiredHillCount = int((PercentHills*actualLandPlotCount)/100)

        while HillsPlaced < RequiredHillCount:

                MaxAltitude = max(NewPlotAltitude)
                NewHills = []

                for I in range(Area):
                        if NewPlotAltitude[I] == MaxAltitude:
                                plotTypes[I] = PlotTypes.PLOT_HILLS
                                NewHills.append([I])
                                NewPlotAltitude[I] = 0
                                HillsPlaced += 1

        # Remove excess hills.

        if HillsPlaced > RequiredHillCount:
		
                ExcessHills = HillsPlaced - RequiredHillCount
                
                for N in range(ExcessHills):
                        I = dice.get(len(NewHills), "Pick a smaller hill.")
                        for J in range(Area):
                                if J in NewHills[I]:
                                        plotTypes[J] = PlotTypes.PLOT_LAND
                                        del NewHills[I]
                                        HillsPlaced -= 1
                                        break

	# Place the widest ocean on the x-wrap.

	ConsecutiveOceanStrips = []
	CurrentConsecutiveOceanStrips = []

	for X in range(width):
                for Y in range(height):
                        I = Y*width + X
                        if plotTypes[I] != PlotTypes.PLOT_OCEAN:
                                CurrentConsecutiveOceanStrips = []
                                break
                        if Y == height - 1:
                                CurrentConsecutiveOceanStrips.append(X)
                if len(CurrentConsecutiveOceanStrips) > len(ConsecutiveOceanStrips):
                        ConsecutiveOceanStrips = []
                        ConsecutiveOceanStrips = CurrentConsecutiveOceanStrips

        if len(ConsecutiveOceanStrips) > 0:
                Shift = ConsecutiveOceanStrips[int(len(ConsecutiveOceanStrips)/2)]
                for X in range(width):
                        for Y in range(height):
                                I = Y*width + X
                                if X >= Shift:
                                        Inew = I - Shift
                                        NewplotTypes[Inew] = plotTypes[I]
                                else:
                                        Inew = I + width - Shift
                                        NewplotTypes[Inew] = plotTypes[I]

        else:
                NewplotTypes = plotTypes
	
	# Finish up.

	return NewplotTypes

#--------------------------------------------------------------------------------------------------------------------------#
# Step 2: Add additional menu options.
#--------------------------------------------------------------------------------------------------------------------------#

selection_titles = [unicode("Min Land Masses:"),
                    unicode("Max Land Masses:"),
                    unicode("Min Continents:"),
                    unicode("Max Continents:"),
                    unicode("Continent Distribution:"),
                    unicode("Continent Placement:"),
                    unicode("Min Oceanic Seperation:"),
                    unicode("Max Oceanic Seperation:"),
                    unicode("Min Ocean:"),
                    unicode("Max Ocean:"),
                    unicode("Coastlines:"),
                    unicode("Hills:"),
                    unicode("Peaks:"),
                    unicode("Mountain Ranges:"),
                    unicode("Altitude Changes:"),
                    ]

selection_names_and_values = [
        [
                ["1 land mass", 1],
                ["2 land masses", 2],
                ["3 land masses", 3],
                ["4 land masses", 4],
                ["5 land masses", 5],
                ["6 land masses", 6],
                ["7 land masses", 7],
                ["8 land masses", 8],
                ["9 land masses", 9],
                ["10 land masses", 10],
                ],
        [
                ["No variation", 0],
                ["1 land mass", 1],
                ["2 land masses", 2],
                ["3 land masses", 3],
                ["4 land masses", 4],
                ["5 land masses", 5],
                ["6 land masses", 6],
                ["7 land masses", 7],
                ["8 land masses", 8],
                ["9 land masses", 9],
                ["10 land masses", 10],
                ],
        [
                ["1 continent per land mass",0],
                ["1 continent",1],
                ["2 continents",2],
                ["3 continents",3],
                ["4 continents",4],
                ["5 continents",5],
                ["6 continents",6],
                ["7 continents",7],
                ["8 continents",8],
                ["9 continents",9],
                ["10 continents",10],
                ["11 continents",11],
                ["12 continents",12],
                ["13 continents",13],
                ["14 continents",14],
                ["15 continents",15],
                ["16 continents",16],
                ["17 continents",17],
                ["18 continents",18],
                ["19 continents",19],
                ["20 continents",20],
                ],
        [
                ["No variation",0],
                ["1 continent",1],
                ["2 continents",2],
                ["3 continents",3],
                ["4 continents",4],
                ["5 continents",5],
                ["6 continents",6],
                ["7 continents",7],
                ["8 continents",8],
                ["9 continents",9],
                ["10 continents",10],
                ["11 continents",11],
                ["12 continents",12],
                ["13 continents",13],
                ["14 continents",14],
                ["15 continents",15],
                ["16 continents",16],
                ["17 continents",17],
                ["18 continents",18],
                ["19 continents",19],
                ["20 continents",20],
                ],
        [
                ["Evenly distributed continents", True],
                ["Randomly distributed continents", False],
                ["Random", -1],
                ],
        [
                ["Normal continent placement", 0],
                ["More rounded land masses", 1],
                ["More snaky land masses", 2],
                ["Random", -1],
                ],
        [
                ["No separation",0],
                ["1 tile of seperation",1],
                ["2 tiles of seperation",2],
                ["3 tiles of seperation",3],
                ["4 tiles of seperation",4],
                ["5 tiles of seperation",5],
                ["6 tiles of seperation",6],
                ["No overseas trade before astronomy",7],
                ["8 tiles of seperation",8],
                ["9 tiles of seperation",9],
                ["10 tiles of seperation",10],
                ["11 tiles of seperation",11],
                ["12 tiles of seperation",12],
                ],
        [
                ["No variation",-1],
                ["No separation",0],
                ["1 tile of separation",1],
                ["2 tiles of seperation",2],
                ["3 tiles of seperation",3],
                ["4 tiles of seperation",4],
                ["5 tiles of seperation",5],
                ["6 tiles of seperation",6],
                ["No overseas trade before astronomy",7],
                ["8 tiles of seperation",8],
                ["9 tiles of seperation",9],
                ["10 tiles of seperation",10],
                ["11 tiles of seperation",11],
                ["12 tiles of seperation",12],
                ],
        [
                ["5% ocean",95],
                ["10% ocean",90],
                ["15% ocean",85],
                ["20% ocean",80],
                ["25% ocean",75],
                ["30% ocean",70],
                ["35% ocean",65],
                ["40% ocean",60],
                ["45% ocean",55],
                ["50% ocean",50],
                ["55% ocean",45],
                ["60% ocean",40],
                ["65% ocean",35],
                ["70% ocean",30],
                ["75% ocean",25],
                ["80% ocean",20],
                ["85% ocean",15],
                ["90% ocean",10],
                ["95% ocean",5],
                ],
        [
                ["No variation",0],
                ["5% ocean",95],
                ["10% ocean",90],
                ["15% ocean",85],
                ["20% ocean",80],
                ["25% ocean",75],
                ["30% ocean",70],
                ["35% ocean",65],
                ["40% ocean",60],
                ["45% ocean",55],
                ["50% ocean",50],
                ["55% ocean",45],
                ["60% ocean",40],
                ["65% ocean",35],
                ["70% ocean",30],
                ["75% ocean",25],
                ["80% ocean",20],
                ["85% ocean",15],
                ["90% ocean",10],
                ["95% ocean",5],
                ],
        [
                ["Standard", 2],
                ["Rougher", 3],
                ["Rugged", 4],
                ["Random", -1],
                ],
        [
                ["Few", -1],
                ["Some", -2],
                ["Normal", -3],
                ["Many", -4],
                ["Many many", -5],
                ["Many many many", -6],
                ["Many many many many", -7],
                ["Lots", -8],
                ["Random", -9],
                ["Highlands few", 40],
                ["Highlands normal", 45],
                ["Highlands many", 50],
                ["Random highlands", 0],
                ],
        [
                ["Few", -1],
                ["Some", -2],
                ["Normal", -3],
                ["Many", -4],
                ["Many many", -5],
                ["Many many many", -6],
                ["Many many many many", -7],
                ["Lots", -8],
                ["Random", -9],
                ["Highlands few", 20],
                ["Highlands normal", 25],
                ["Highlands many", 30],
                ["Random highlands", 0],
                ],
        [
                ["No ranges", 0],
                ["Ranges", 1],
                ["All ranges", 2],
                ["Random", -1],
		],
        [
                ["No clumped hills and peaks", 0],
                ["Clumped hills and peaks", 1],
                ["Random", -1],
		],
        ]

#--------------------------------------------------------------------------------------------------------------------------#
# Step 3: Further functions.
#--------------------------------------------------------------------------------------------------------------------------#

def isSeaLevelMap():
        return 0

def isRandomCustomMapOption(argsList):
        return False

def getDescription():
	return unicode("LandMasses Map Size")

def getNumCustomMapOptions():
	return len(selection_titles)

def getCustomMapOptionName(argsList):
	return selection_titles[argsList[0]]

def getSelectedMapValue(OptionName):
        
	gc = CyGlobalContext()
	cymap = CyMap()
	dice = gc.getGame().getMapRand()
	
	for Option in range(len(selection_titles)):
		if selection_titles[Option] == OptionName:
                        break
	
	Choice = int(cymap.getCustomMapOption(Option))
	
	if Choice >= len(selection_names_and_values[Option]):
		Choice = 0
				
	cachedMenuChoices[Option] = Choice
	
	return selection_names_and_values[Option][Choice][1]

def getNumCustomMapOptionValues(argsList):
        return len(selection_names_and_values[argsList[0]])

def getCustomMapOptionDescAt(argsList):
	return unicode(selection_names_and_values[argsList[0]][argsList[1]][0])

# Save selected map options.

def saveSettings():

        global isamodule

        if isamodule == True:
                return
    
	cymap = CyMap()
	settings = open('LandMasses Lands.cfg', 'w')
	SavedSettings = []
	for Option in range(len(selection_titles)):
		Choice = int(cymap.getCustomMapOption(Option))
		ChoiceName = selection_names_and_values[Option][Choice][0]
		SavedSettings.append((selection_titles[Option], ChoiceName))
		
	print SavedSettings
	try:
		pickle.dump(SavedSettings, settings)
	except Exception, inst:
		print "    Pickling Error trying to save smartmap settings to LandMasses Lands.cfg", inst
	settings.close()

# Find previously selected map options.

def getCustomMapOptionDefault(argsList):
	result = 0
	try:
		settings = open('LandMasses Lands.cfg', 'r')
		SavedSettings = pickle.load(settings)
		for EachOption in range(len(SavedSettings)):
			Option, ChoiceName = SavedSettings[argsList[0]]
			if Option == selection_titles[argsList[0]]:
				for EachChoice in range(len(selection_names_and_values[argsList[0]])):
					EachChoiceName, EachChoiceValue = selection_names_and_values[argsList[0]][EachChoice]
					if EachChoiceName == ChoiceName:
						result = EachChoice
		settings.close()
	except IOError:
		print "    Couldn't find LandMasses Lands.cfg"
	except EOFError:
		print "    Bad contents in LandMasses Lands.cfg"
		
	return result

def isAdvancedMap():
	return 1

def beforeInit():
	global cachedMenuChoices
	cachedMenuChoices = []
	for Choice in range(len(selection_names_and_values)):
		cachedMenuChoices.append((0))
		
def beforeGeneration():
	global cachedMenuChoices
	for Choice in range(len(selection_names_and_values)):
		if selection_names_and_values[Choice][0] != "Wrap:":
			cachedMenuChoices[Choice] = 0

def GetNewTileIndex(I, direction):
	
	global width
	global Area

	dx, dy = direction
	Inew = I + dx + (width*dy)

	if Inew < 0 or Inew >= Area:
		Inew = -1

	return (Inew)

def GetDistance(Ione, Itwo):
	
	global width

	x = abs(Ione - Itwo)
	y = 0

	while x >= width:
		x -= width
		y += 1

	if Itwo > Ione:
		y = -y

	if x > int(width/2):
		x = width - x
			
	return (x, y)

#--------------------------------------------------------------------------------------------------------------------------#
# Build Notes.
#--------------------------------------------------------------------------------------------------------------------------#

# Version 1.0:
# Seems to work as intended.
